/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.entities;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.block.GrassBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FrogEntity
extends CreatureEntity {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(FrogEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final int NUM_COLORS = 5;

    public FrogEntity(EntityType<? extends FrogEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new MoveHelperController(this);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 5.0).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new HopGoal(this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(COLOR, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Color", this.getColor());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setColor(compound.func_74762_e("Color"));
    }

    public int getColor() {
        return (Integer)this.func_184212_Q().func_187225_a(COLOR);
    }

    public void setColor(int color) {
        this.func_184212_Q().func_187227_b(COLOR, (Object)color);
    }

    public int getRandomColor(Random rand) {
        return rand.nextInt(5);
    }

    public static boolean canSpawn(EntityType<FrogEntity> entity, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof GrassBlock || world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150346_d;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        this.setColor(this.getRandomColor(world.func_201674_k()));
        return super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    protected void func_85033_bc() {
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 0;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(100) + 100;
    }

    static class MoveHelperController
    extends MovementController {
        private float yRot;
        private int jumpDelay;
        private final FrogEntity frog;

        public MoveHelperController(FrogEntity entity) {
            super((MobEntity)entity);
            this.frog = entity;
            this.yRot = 180.0f * entity.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float yRot, boolean p_179920_2_) {
            this.yRot = yRot;
        }

        public void setWantedMovement(double speedModifier) {
            this.field_75645_e = speedModifier;
            this.field_188491_h = MovementController.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != MovementController.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = MovementController.Action.WAIT;
                if (this.field_75648_a.func_233570_aj_()) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233821_d_)));
                    if (this.field_75648_a.func_70090_H()) {
                        this.field_75648_a.func_70659_e((float)(1.5 * this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233821_d_)));
                    }
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.frog.getJumpDelay();
                        if (!this.frog.func_70090_H()) {
                            this.frog.func_70683_ar().func_75660_a();
                        } else {
                            Vector3d vector3d = this.frog.func_213322_ci();
                            this.frog.func_213293_j(vector3d.field_72450_a * 5.0, (double)this.frog.func_175134_bD() * 0.5, vector3d.field_72449_c * 5.0);
                        }
                    } else {
                        this.frog.field_70702_br = 0.0f;
                        this.frog.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233821_d_)));
                }
            }
        }
    }

    static class HopGoal
    extends Goal {
        private final FrogEntity frog;

        public HopGoal(FrogEntity frog) {
            this.frog = frog;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !this.frog.func_184218_aH();
        }

        public void func_75246_d() {
            ((MoveHelperController)this.frog.func_70605_aq()).setWantedMovement(1.0);
        }
    }
}

